/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.completable;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Completable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.CompletableObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.CompletableSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.CompositeException;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Predicate;

public final class CompletableOnErrorComplete
extends Completable {
    final CompletableSource source;
    final Predicate<? super Throwable> predicate;

    public CompletableOnErrorComplete(CompletableSource source, Predicate<? super Throwable> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new OnError(observer));
    }

    final class OnError
    implements CompletableObserver {
        private final CompletableObserver downstream;

        OnError(CompletableObserver observer) {
            this.downstream = observer;
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            boolean b;
            try {
                b = CompletableOnErrorComplete.this.predicate.test(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(new CompositeException(e, ex));
                return;
            }
            if (b) {
                this.downstream.onComplete();
            } else {
                this.downstream.onError(e);
            }
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.downstream.onSubscribe(d);
        }
    }
}

